/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS BCD DECADE UP/DOWN  COUNTER 
TRUTHTABLE     : 
+--------------------------------+-----------------------+
|             INPUT              |                       |
+--------------------------------+       OPERATION       |
|  CLR   LOAD_   UP    DOWN      |                       |
+--------------------------------+-----------------------+
|   H      X      X      X       |   Asynchronous clear  |
|                                |                       |
|   L      L      X      X       |   Load Parrallel Data |
|                   _            |                       |
|   L      H      _/     H       |   Decade Count Up     |
|                         _      |                       |
|   L      H       H    _/       |   Decade Count Down   |
|                                |                       |
+--------------------------------+-----------------------+

   Note : 1. CO_ goes low at the maximum terminal count for 
             half clock pulse duration.
          2. BO_ goes low at the minimum terminal count for           
             half clock pulse duration.
           
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a192 (b, qb, qa, down, up, qc, qd, d, c, ldn, con, bon, clr, a);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		ldn,
		up,
		down,
		clr,
		a,
		b,
		c,
		d;
	output
		qa,
		qb,
		qc,
		qd,
		bon,
		con;
    reg
        NOTIFY_REG;
    not
	N1 (mr_, clr);
    and
	A2 (en2, ldn, mr_, down);
    and
	A3 (en3, ldn, mr_, up);
    not  
	M192_inst_I1 (m192_inst_wi1, clr);
    not  
	M192_inst_I2 (m192_inst_wi2, ldn);
    not
	M192_inst_I3 (m192_inst_wi3, a);
    not
	M192_inst_I4 (m192_inst_wi4, b);
    not
	M192_inst_I5 (m192_inst_wi5, c);
    not
	M192_inst_I6 (m192_inst_wi6, d);
    not  
	M192_inst_I7 (m192_inst_wi7, up);
    not  
	M192_inst_I8 (m192_inst_wi8, down);
    or
	M192_inst_O1 (m192_inst_wo1, m192_inst_wa9, m192_inst_wa10);
    xor
	M192_inst_XO1 (m192_inst_wxo1, m192_inst_wa5, m192_inst_qbint);
    xor
	M192_inst_XO2 (m192_inst_wxo2, m192_inst_wa6, m192_inst_qbint);
    xor
	M192_inst_XO3 (m192_inst_wxo3, m192_inst_wa7, m192_inst_qcint);
    xor
	M192_inst_XO4 (m192_inst_wxo4, m192_inst_wa8, m192_inst_qcint);
    xor
	M192_inst_XO5 (m192_inst_wxo5, m192_inst_wa11, m192_inst_qdint);
    and  
	M192_inst_A1 (m192_inst_wa1, m192_inst_wna1, m192_inst_wi1);
    and  
	M192_inst_A2 (m192_inst_wa2, m192_inst_wna2, m192_inst_wi1);
    and  
	M192_inst_A3 (m192_inst_wa3, m192_inst_wna3, m192_inst_wi1);
    and  
	M192_inst_A4 (m192_inst_wa4, m192_inst_wna4, m192_inst_wi1);
    and
	M192_inst_A5 (m192_inst_wa5, m192_inst_qaint, m192_inst_wqnd);
    and
	M192_inst_A6 (m192_inst_wa6, m192_inst_wqna, m192_inst_wna9);
    and
	M192_inst_A7 (m192_inst_wa7, m192_inst_qaint, m192_inst_qbint);
    and
	M192_inst_A8 (m192_inst_wa8, m192_inst_wna9, m192_inst_wqna, m192_inst_wqnb);
    and
	M192_inst_A9 (m192_inst_wa9, m192_inst_wqna, m192_inst_qdint);
    and
	M192_inst_A10 (m192_inst_wa10, m192_inst_qaint, m192_inst_qbint, m192_inst_qcint, m192_inst_wqnd);
    and
	M192_inst_A11 (m192_inst_wa11, m192_inst_wqna, m192_inst_wqnb, m192_inst_wqnc);
    and  
	M192_inst_A12 (m192_inst_wa12, up, down);
    nand
	M192_inst_NA1 (m192_inst_wna1, m192_inst_wi3, m192_inst_wi2);
    nand
	M192_inst_NA2 (m192_inst_wna2, m192_inst_wi2, m192_inst_wi4);
    nand
	M192_inst_NA3 (m192_inst_wna3, m192_inst_wi2, m192_inst_wi5);
    nand
	M192_inst_NA4 (m192_inst_wna4, m192_inst_wi2, m192_inst_wi6);
    nand  
	M192_inst_NA5 (m192_inst_wna5, a, m192_inst_wi1, m192_inst_wi2);
    nand  
	M192_inst_NA6 (m192_inst_wna6, b, m192_inst_wi1, m192_inst_wi2);
    nand  
	M192_inst_NA7 (m192_inst_wna7, c, m192_inst_wi1, m192_inst_wi2);
    nand  
	M192_inst_NA8 (m192_inst_wna8, d, m192_inst_wi1, m192_inst_wi2);
    nand
	M192_inst_NA9 (m192_inst_wna9, m192_inst_wqnb, m192_inst_wqnc, m192_inst_wqnd);
    nand  
	M192_inst_NA19 (con, m192_inst_qaint, m192_inst_qdint, m192_inst_wi7);
    nand  
	M192_inst_NA20 (bon, m192_inst_wqna, m192_inst_wqnb, m192_inst_wqnc, m192_inst_wqnd, m192_inst_wi8);
    buf  
	  (qa, m192_inst_qaint);
    buf  
	  (qb, m192_inst_qbint);
    buf  
	  (qc, m192_inst_qcint);
    buf  
	  (qd, m192_inst_qdint);
    not
	  (m192_inst_wqna, m192_inst_qaint);
    not
	  (m192_inst_wqnb, m192_inst_qbint);
    not
	  (m192_inst_wqnc, m192_inst_qcint);
    not
	  (m192_inst_wqnd, m192_inst_qdint);
    not
	  (m192_inst_wqn5, m192_inst_wq5);
    U_AO_2_2
	M192_inst_INST1_inst1 (m192_inst_wna16, m192_inst_wq5, m192_inst_wxo1, m192_inst_wxo2, m192_inst_wqn5);
    U_AO_2_2
	M192_inst_INST2_inst1 (m192_inst_wna17, m192_inst_wq5, m192_inst_wxo3, m192_inst_wxo4, m192_inst_wqn5);
    U_AO_2_2
	M192_inst_INST3_inst1 (m192_inst_wna18, m192_inst_wq5, m192_inst_wo1, m192_inst_wxo5, m192_inst_wqn5);
    U_FD_P_RB_SB_NO
	  (m192_inst_qaint, m192_inst_wqna, m192_inst_wa12, m192_inst_wa1, m192_inst_wna5, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m192_inst_qbint, m192_inst_wna16, m192_inst_wa12, m192_inst_wa2, m192_inst_wna6, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m192_inst_qcint, m192_inst_wna17, m192_inst_wa12, m192_inst_wa3, m192_inst_wna7, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m192_inst_qdint, m192_inst_wna18, m192_inst_wa12, m192_inst_wa4, m192_inst_wna8, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m192_inst_wq5, 1'b0, 1'b0, down, up, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
